#install.packages("pROC")


library(pROC)                    #library package
inputFile="neural.predict.txt"      #input file
setwd("E:\\metabolism\\LGG\\15.ANN\\3.neuralROC")    

#Read the input file and tidy the input file
rt=read.table(inputFile, header=T, sep="\t", check.names=F, row.names=1)
y=gsub("(.*)\\_(.*)", "\\2", row.names(rt))
y=ifelse(y=="C1", 0, 1)

#Plot the ROC curve
roc1=roc(y, as.numeric(rt[,2]))
ci1=ci.auc(roc1, method="bootstrap")
ciVec=as.numeric(ci1)
pdf(file="ROC.pdf", width=5, height=5)
plot(roc1, print.auc=TRUE, col="#4A71C0", legacy.axes=T, main="neuralNet model")
text(0.39, 0.43, paste0("95% CI: ",sprintf("%.03f",ciVec[1]),"-",sprintf("%.03f",ciVec[3])), col="#4A71C0")
dev.off()

